/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.contentAssist;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.core.PHPVersionProvider;
import com.aptana.editor.php.internal.ui.editor.PHPVersionDocumentManager;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import javax.swing.text.Segment;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org2.eclipse.php.internal.core.PHPVersion;
import org2.eclipse.php.internal.core.documentModel.parser.AbstractPhpLexer;
import org2.eclipse.php.internal.core.documentModel.parser.PhpLexerFactory;

public class PHPScopeScanner
implements ITokenScanner {
    private AbstractPhpLexer lexer;
    private int regionOffset;
    private int originalOffset;
    private int originalLength;
    private int prevTokenOffset;
    private int duplicateStartCount;
    private ITypedRegion[] partitions;
    private char[] content;
    private IDocument document;

    public int getTokenLength() {
        return this.lexer.yylength();
    }

    public int getTokenOffset() {
        return this.regionOffset + this.lexer.getTokenStart();
    }

    public IToken nextToken() {
        try {
            String token = this.lexer.getNextToken();
            int tokenOffset = this.getTokenOffset();
            if (this.prevTokenOffset == tokenOffset) {
                if (this.duplicateStartCount == 3) {
                    this.duplicateStartCount = 0;
                    this.dispose();
                    return Token.EOF;
                }
                ++this.duplicateStartCount;
            } else {
                this.duplicateStartCount = 0;
                this.prevTokenOffset = tokenOffset;
                if (token == null) {
                    this.dispose();
                    return Token.EOF;
                }
            }
            if ("PHP_CLOSETAG".equals(token)) {
                ITypedRegion nextPhpRegion;
                if (this.partitions == null) {
                    try {
                        this.partitions = TextUtilities.computePartitioning((IDocument)this.document, (String)"__dftl_partitioning", (int)this.originalOffset, (int)this.originalLength, (boolean)false);
                    }
                    catch (BadLocationException e) {
                        IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP scope-scanner error", (Throwable)e);
                    }
                }
                if ((nextPhpRegion = this.getNextPhpRegion()) != null) {
                    int nextRegionOffset = nextPhpRegion.getOffset() - this.originalOffset;
                    Segment segment = new Segment(this.content, nextRegionOffset, this.content.length - nextRegionOffset);
                    this.lexer.reset(segment);
                    this.regionOffset = nextPhpRegion.getOffset();
                }
            }
            return new Token((Object)token);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP scope-scanner error", (Throwable)e);
            this.dispose();
            return Token.EOF;
        }
    }

    private void dispose() {
        this.content = null;
        this.partitions = null;
        this.lexer = null;
        this.document = null;
    }

    protected ITypedRegion getNextPhpRegion() {
        if (this.partitions != null) {
            int offset = this.getTokenOffset() + this.getTokenLength();
            ITypedRegion[] iTypedRegionArray = this.partitions;
            int n = this.partitions.length;
            int n2 = 0;
            while (n2 < n) {
                ITypedRegion region = iTypedRegionArray[n2];
                if (region.getOffset() > offset && region.getType().startsWith("__php__dftl_partition_content_type")) {
                    return region;
                }
                ++n2;
            }
        }
        return null;
    }

    public void setRange(IDocument document, int offset, int length) {
        this.document = document;
        this.originalOffset = offset;
        this.originalLength = length;
        this.regionOffset = this.originalOffset;
        this.prevTokenOffset = -1;
        PHPVersion phpVersion = PHPVersionDocumentManager.getPHPVersion(document);
        if (phpVersion == null) {
            phpVersion = PHPVersionProvider.getDefaultPHPVersion();
        }
        try {
            this.content = document.get(offset, length).toCharArray();
            this.lexer = PhpLexerFactory.createLexer((Reader)new CharArrayReader(this.content), (PHPVersion)phpVersion);
            int state = this.lexer.getClass().getField("ST_PHP_IN_SCRIPTING").getInt(this.lexer);
            this.lexer.initialize(state);
            this.lexer.setPatterns(null);
            this.lexer.setAspTags(true);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"PHP scope-scanner error (setRange)", (Throwable)e);
        }
    }
}

